% =========================================================================
%   Praktikum MATLAB/Simulink I
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Versuch 5
% Versuchsdurchfhrung 5.2.1

% Parameter Ventilator deklarieren

cM = 6.2133e-3;   % Motorkonstante
JP = 1.6833e-4;    % Massentrgheitsmoment des Propellers
L = 5.34e-6;      % Induktivitt des Elektromotors
R = 0.1655;        % Innenwiderstand des Elektromotors
beta = 1/12500000; % Proportionalittsfaktor des Lastmoments
w_s = 320.8745;    % Arbeitspunkt der Winkelgeschwindigkeit
K = 2*beta*w_s;

%Parameter Pendelschrauber deklarieren

cW = 0.75;         % Reibekoeffizient Wippe
g = 9.81;          % Erdbeschleunigung
HL = 0.48;         % Hebellnge (links)
HR = 1.52;         % Hebellnge (rechts)
JW = 1.9141;       % Massentrgheitsmoment Wippe
mL = 2.01134;      % Masse Gewicht (links)
mP = 0.48;         % Masse Propeller
mSL = 0.1404;      % Masse Stangenabschnitt (links)
mSR = 0.44;        % Masse Stangenabschnitt (rechts)
SL = 0.5;          % Stange (links)
SR = 1.5;          % Stange (rechts)
alpha_s = 0;       % Arbeitspunkt des Ausgangswinkels
gamma = 3.7019e-6;% Proportionalittsfaktor des Schubs

k = -0.5 * mSL * g * SL - mL * g * HL + 0.5 * mSR * g * SR + mP * g * HR;
w_s = sqrt( k / (HR * gamma) * cos(alpha_s) );